// By EVOLVED
// www.evolved-software.com

//--------------
// un-tweaks
//--------------
   uniform mat4 agk_WorldViewProj;
   uniform mat4 agk_ViewProj;
   uniform mat4 agk_World;
   uniform mat3 agk_WorldNormal;
   uniform vec3 agk_CameraPos;
   uniform vec4 uvBounds0;

//--------------
// tweaks
//--------------
   uniform vec4 TreeWindTimer;
   uniform vec4 TreeWindSize;
   uniform vec3 TreeWindPower;

//--------------
// attributes
//--------------
    attribute vec3 position;
    attribute vec2 uv;
    attribute vec3 normal;
    attribute vec3 tangent;
    attribute vec3 color;

//--------------
// Vs Out
//--------------
    varying vec2 Vs_Tex;
    varying vec3 Vs_TBNRow1;
    varying vec3 Vs_TBNRow2;
    varying vec3 Vs_TBNRow3;
    varying vec3 Vs_WorldPos;
    varying vec3 Vs_ViewVec;
    varying vec4 Vs_Proj;

//--------------
// vertex shader
//--------------
   void main()
     {

	vec3 WorldPos=(agk_World*vec4(position,1.0)).xyz;
	vec3 Normals=normalize(agk_WorldNormal*normal);
	vec3 GlobalWind=(WorldPos.xyz/TreeWindSize.x)+TreeWindTimer.x;
	GlobalWind=vec3(cos(GlobalWind.x),0.0,sin(GlobalWind.z));
	GlobalWind.y=1.0+abs(dot(GlobalWind.x,GlobalWind.z));
   	vec3 WindForce=(WorldPos.xyz/TreeWindSize.x)+TreeWindTimer.y-GlobalWind;
	WindForce=vec3(cos(WindForce.x),0.0,sin(WindForce.y));
	vec3 WindAnimate=WindForce*TreeWindPower.x*(position.y/TreeWindSize.y);
	float WindVariant=TreeWindTimer.z+(color.y*10.0);
	WindAnimate.xz +=vec2(cos(WindVariant),sin(WindVariant))*TreeWindPower.y*color.z;
	vec3 WindFlutter=(WorldPos.xyz/TreeWindSize.w)+(TreeWindTimer.w)+color.y;
	WindAnimate +=abs(Normals)*sin(dot(WindFlutter,vec3(1.0,1.0,1.0)))*TreeWindPower.z*color.x;
	WorldPos +=WindAnimate*GlobalWind.y;
	vec4 Pos=agk_ViewProj*vec4(WorldPos,1);
	gl_Position=Pos;
	Vs_Tex=uv*uvBounds0.xy+uvBounds0.zw;
	vec3 Tangent=normalize(agk_WorldNormal*tangent);
	Vs_TBNRow1=Tangent;
	Vs_TBNRow2=cross(Normals,Tangent);
	Vs_TBNRow3=Normals;
	Vs_WorldPos=WorldPos;
	vec3 ViewVec=agk_CameraPos-WorldPos;
	Vs_ViewVec=ViewVec;
        Vs_Proj=vec4(Pos.x*0.5+0.5*Pos.w,Pos.y*0.5+0.5*Pos.w,Pos.z,Pos.w);
     }
